package gov.va.genisis2.exceptions;

public class GenisisServiceException extends Exception {

	private static final long serialVersionUID = -177450360812316059L;
	
	/** The error message. */
	private final String message;
	
	/** The throwable. */
	private final Throwable throwable;

	/**
	 * @param message The error message
	 */
	public GenisisServiceException(String message) {
		super(message);
		this.message = message;
		this.throwable = null;
	}

	/**
	 * @param message The error message
	 * @param throwable The throwable exception
	 */
	public GenisisServiceException(String message, Throwable throwable) {
		super(message, throwable);
		this.message = message;
		this.throwable = throwable;
	}
	
	/**
	 * @return the message
	 */
	@Override
	public String getMessage() {
		return message;
	}

	/**
	 * @return the throwable
	 */
	public Throwable getThrowable() {
		return throwable;
	}
}
